/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Send and receive messages from NATS messaging system.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface NatsEndpointBuilderFactory {

    /**
     * Builder for endpoint consumers for the Nats component.
     */
    public interface NatsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedNatsEndpointConsumerBuilder advanced() {
            return (AdvancedNatsEndpointConsumerBuilder) this;
        }
        /**
         * Timeout for connection attempts. (in milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2000
         * Group: common
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder connectionTimeout(int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Timeout for connection attempts. (in milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2000
         * Group: common
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder connectionTimeout(String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Define if we want to flush connection when stopping or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param flushConnection the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder flushConnection(boolean flushConnection) {
            doSetProperty("flushConnection", flushConnection);
            return this;
        }
        /**
         * Define if we want to flush connection when stopping or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param flushConnection the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder flushConnection(String flushConnection) {
            doSetProperty("flushConnection", flushConnection);
            return this;
        }
        /**
         * Set the flush timeout (in milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param flushTimeout the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder flushTimeout(int flushTimeout) {
            doSetProperty("flushTimeout", flushTimeout);
            return this;
        }
        /**
         * Set the flush timeout (in milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param flushTimeout the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder flushTimeout(String flushTimeout) {
            doSetProperty("flushTimeout", flushTimeout);
            return this;
        }
        /**
         * maximum number of pings have not received a response allowed by the
         * client.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param maxPingsOut the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder maxPingsOut(int maxPingsOut) {
            doSetProperty("maxPingsOut", maxPingsOut);
            return this;
        }
        /**
         * maximum number of pings have not received a response allowed by the
         * client.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param maxPingsOut the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder maxPingsOut(String maxPingsOut) {
            doSetProperty("maxPingsOut", maxPingsOut);
            return this;
        }
        /**
         * Max reconnection attempts.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 60
         * Group: common
         * 
         * @param maxReconnectAttempts the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder maxReconnectAttempts(int maxReconnectAttempts) {
            doSetProperty("maxReconnectAttempts", maxReconnectAttempts);
            return this;
        }
        /**
         * Max reconnection attempts.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 60
         * Group: common
         * 
         * @param maxReconnectAttempts the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder maxReconnectAttempts(String maxReconnectAttempts) {
            doSetProperty("maxReconnectAttempts", maxReconnectAttempts);
            return this;
        }
        /**
         * Turn off echo. If supported by the gnatsd version you are connecting
         * to this flag will prevent the server from echoing messages back to
         * the connection if it has subscriptions on the subject being published
         * to.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param noEcho the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder noEcho(boolean noEcho) {
            doSetProperty("noEcho", noEcho);
            return this;
        }
        /**
         * Turn off echo. If supported by the gnatsd version you are connecting
         * to this flag will prevent the server from echoing messages back to
         * the connection if it has subscriptions on the subject being published
         * to.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param noEcho the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder noEcho(String noEcho) {
            doSetProperty("noEcho", noEcho);
            return this;
        }
        /**
         * Whether or not randomizing the order of servers for the connection
         * attempts.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param noRandomizeServers the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder noRandomizeServers(boolean noRandomizeServers) {
            doSetProperty("noRandomizeServers", noRandomizeServers);
            return this;
        }
        /**
         * Whether or not randomizing the order of servers for the connection
         * attempts.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param noRandomizeServers the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder noRandomizeServers(String noRandomizeServers) {
            doSetProperty("noRandomizeServers", noRandomizeServers);
            return this;
        }
        /**
         * Whether or not running in pedantic mode (this affects performance).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param pedantic the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder pedantic(boolean pedantic) {
            doSetProperty("pedantic", pedantic);
            return this;
        }
        /**
         * Whether or not running in pedantic mode (this affects performance).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param pedantic the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder pedantic(String pedantic) {
            doSetProperty("pedantic", pedantic);
            return this;
        }
        /**
         * Ping interval to be aware if connection is still alive (in
         * milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 120000
         * Group: common
         * 
         * @param pingInterval the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder pingInterval(int pingInterval) {
            doSetProperty("pingInterval", pingInterval);
            return this;
        }
        /**
         * Ping interval to be aware if connection is still alive (in
         * milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 120000
         * Group: common
         * 
         * @param pingInterval the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder pingInterval(String pingInterval) {
            doSetProperty("pingInterval", pingInterval);
            return this;
        }
        /**
         * Whether or not using reconnection feature.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param reconnect the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder reconnect(boolean reconnect) {
            doSetProperty("reconnect", reconnect);
            return this;
        }
        /**
         * Whether or not using reconnection feature.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param reconnect the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder reconnect(String reconnect) {
            doSetProperty("reconnect", reconnect);
            return this;
        }
        /**
         * Waiting time before attempts reconnection (in milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2000
         * Group: common
         * 
         * @param reconnectTimeWait the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder reconnectTimeWait(int reconnectTimeWait) {
            doSetProperty("reconnectTimeWait", reconnectTimeWait);
            return this;
        }
        /**
         * Waiting time before attempts reconnection (in milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2000
         * Group: common
         * 
         * @param reconnectTimeWait the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder reconnectTimeWait(String reconnectTimeWait) {
            doSetProperty("reconnectTimeWait", reconnectTimeWait);
            return this;
        }
        /**
         * Interval to clean up cancelled/timed out requests.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 5000
         * Group: common
         * 
         * @param requestCleanupInterval the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder requestCleanupInterval(int requestCleanupInterval) {
            doSetProperty("requestCleanupInterval", requestCleanupInterval);
            return this;
        }
        /**
         * Interval to clean up cancelled/timed out requests.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 5000
         * Group: common
         * 
         * @param requestCleanupInterval the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder requestCleanupInterval(String requestCleanupInterval) {
            doSetProperty("requestCleanupInterval", requestCleanupInterval);
            return this;
        }
        /**
         * URLs to one or more NAT servers. Use comma to separate URLs when
         * specifying multiple servers.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param servers the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder servers(String servers) {
            doSetProperty("servers", servers);
            return this;
        }
        /**
         * Whether or not running in verbose mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param verbose the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder verbose(boolean verbose) {
            doSetProperty("verbose", verbose);
            return this;
        }
        /**
         * Whether or not running in verbose mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param verbose the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder verbose(String verbose) {
            doSetProperty("verbose", verbose);
            return this;
        }
        /**
         * Stop receiving messages from a topic we are subscribing to after
         * maxMessages.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param maxMessages the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder maxMessages(String maxMessages) {
            doSetProperty("maxMessages", maxMessages);
            return this;
        }
        /**
         * Consumer thread pool size (default is 10).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 10
         * Group: consumer
         * 
         * @param poolSize the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder poolSize(int poolSize) {
            doSetProperty("poolSize", poolSize);
            return this;
        }
        /**
         * Consumer thread pool size (default is 10).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 10
         * Group: consumer
         * 
         * @param poolSize the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder poolSize(String poolSize) {
            doSetProperty("poolSize", poolSize);
            return this;
        }
        /**
         * The Queue name if we are using nats for a queue configuration.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param queueName the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder queueName(String queueName) {
            doSetProperty("queueName", queueName);
            return this;
        }
        /**
         * Can be used to turn off sending back reply message in the consumer.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param replyToDisabled the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder replyToDisabled(boolean replyToDisabled) {
            doSetProperty("replyToDisabled", replyToDisabled);
            return this;
        }
        /**
         * Can be used to turn off sending back reply message in the consumer.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param replyToDisabled the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder replyToDisabled(String replyToDisabled) {
            doSetProperty("replyToDisabled", replyToDisabled);
            return this;
        }
        /**
         * If we use useCredentialsFile to true we'll need to set the
         * credentialsFilePath option. It can be loaded by default from
         * classpath, but you can prefix with classpath:, file:, or http: to
         * load the resource from different systems.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param credentialsFilePath the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder credentialsFilePath(String credentialsFilePath) {
            doSetProperty("credentialsFilePath", credentialsFilePath);
            return this;
        }
        /**
         * Set secure option indicating TLS is required.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder secure(boolean secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Set secure option indicating TLS is required.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder secure(String secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder sslContextParameters(org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NatsEndpointConsumerBuilder sslContextParameters(String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Nats component.
     */
    public interface AdvancedNatsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default NatsEndpointConsumerBuilder basic() {
            return (NatsEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointConsumerBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointConsumerBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Reference an already instantiated connection to Nats server.
         * 
         * The option is a: <code>io.nats.client.Connection</code> type.
         * 
         * Group: advanced
         * 
         * @param connection the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointConsumerBuilder connection(io.nats.client.Connection connection) {
            doSetProperty("connection", connection);
            return this;
        }
        /**
         * Reference an already instantiated connection to Nats server.
         * 
         * The option will be converted to a
         * <code>io.nats.client.Connection</code> type.
         * 
         * Group: advanced
         * 
         * @param connection the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointConsumerBuilder connection(String connection) {
            doSetProperty("connection", connection);
            return this;
        }
        /**
         * Define the header filtering strategy.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointConsumerBuilder headerFilterStrategy(org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Define the header filtering strategy.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointConsumerBuilder headerFilterStrategy(String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Whether or not connection trace messages should be printed to
         * standard out for fine grained debugging of connection issues.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param traceConnection the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointConsumerBuilder traceConnection(boolean traceConnection) {
            doSetProperty("traceConnection", traceConnection);
            return this;
        }
        /**
         * Whether or not connection trace messages should be printed to
         * standard out for fine grained debugging of connection issues.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param traceConnection the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointConsumerBuilder traceConnection(String traceConnection) {
            doSetProperty("traceConnection", traceConnection);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Nats component.
     */
    public interface NatsEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedNatsEndpointProducerBuilder advanced() {
            return (AdvancedNatsEndpointProducerBuilder) this;
        }

        /**
         * Timeout for connection attempts. (in milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2000
         * Group: common
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder connectionTimeout(int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Timeout for connection attempts. (in milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2000
         * Group: common
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder connectionTimeout(String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Define if we want to flush connection when stopping or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param flushConnection the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder flushConnection(boolean flushConnection) {
            doSetProperty("flushConnection", flushConnection);
            return this;
        }
        /**
         * Define if we want to flush connection when stopping or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param flushConnection the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder flushConnection(String flushConnection) {
            doSetProperty("flushConnection", flushConnection);
            return this;
        }
        /**
         * Set the flush timeout (in milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param flushTimeout the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder flushTimeout(int flushTimeout) {
            doSetProperty("flushTimeout", flushTimeout);
            return this;
        }
        /**
         * Set the flush timeout (in milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param flushTimeout the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder flushTimeout(String flushTimeout) {
            doSetProperty("flushTimeout", flushTimeout);
            return this;
        }
        /**
         * maximum number of pings have not received a response allowed by the
         * client.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param maxPingsOut the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder maxPingsOut(int maxPingsOut) {
            doSetProperty("maxPingsOut", maxPingsOut);
            return this;
        }
        /**
         * maximum number of pings have not received a response allowed by the
         * client.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param maxPingsOut the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder maxPingsOut(String maxPingsOut) {
            doSetProperty("maxPingsOut", maxPingsOut);
            return this;
        }
        /**
         * Max reconnection attempts.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 60
         * Group: common
         * 
         * @param maxReconnectAttempts the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder maxReconnectAttempts(int maxReconnectAttempts) {
            doSetProperty("maxReconnectAttempts", maxReconnectAttempts);
            return this;
        }
        /**
         * Max reconnection attempts.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 60
         * Group: common
         * 
         * @param maxReconnectAttempts the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder maxReconnectAttempts(String maxReconnectAttempts) {
            doSetProperty("maxReconnectAttempts", maxReconnectAttempts);
            return this;
        }
        /**
         * Turn off echo. If supported by the gnatsd version you are connecting
         * to this flag will prevent the server from echoing messages back to
         * the connection if it has subscriptions on the subject being published
         * to.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param noEcho the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder noEcho(boolean noEcho) {
            doSetProperty("noEcho", noEcho);
            return this;
        }
        /**
         * Turn off echo. If supported by the gnatsd version you are connecting
         * to this flag will prevent the server from echoing messages back to
         * the connection if it has subscriptions on the subject being published
         * to.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param noEcho the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder noEcho(String noEcho) {
            doSetProperty("noEcho", noEcho);
            return this;
        }
        /**
         * Whether or not randomizing the order of servers for the connection
         * attempts.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param noRandomizeServers the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder noRandomizeServers(boolean noRandomizeServers) {
            doSetProperty("noRandomizeServers", noRandomizeServers);
            return this;
        }
        /**
         * Whether or not randomizing the order of servers for the connection
         * attempts.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param noRandomizeServers the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder noRandomizeServers(String noRandomizeServers) {
            doSetProperty("noRandomizeServers", noRandomizeServers);
            return this;
        }
        /**
         * Whether or not running in pedantic mode (this affects performance).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param pedantic the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder pedantic(boolean pedantic) {
            doSetProperty("pedantic", pedantic);
            return this;
        }
        /**
         * Whether or not running in pedantic mode (this affects performance).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param pedantic the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder pedantic(String pedantic) {
            doSetProperty("pedantic", pedantic);
            return this;
        }
        /**
         * Ping interval to be aware if connection is still alive (in
         * milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 120000
         * Group: common
         * 
         * @param pingInterval the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder pingInterval(int pingInterval) {
            doSetProperty("pingInterval", pingInterval);
            return this;
        }
        /**
         * Ping interval to be aware if connection is still alive (in
         * milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 120000
         * Group: common
         * 
         * @param pingInterval the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder pingInterval(String pingInterval) {
            doSetProperty("pingInterval", pingInterval);
            return this;
        }
        /**
         * Whether or not using reconnection feature.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param reconnect the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder reconnect(boolean reconnect) {
            doSetProperty("reconnect", reconnect);
            return this;
        }
        /**
         * Whether or not using reconnection feature.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param reconnect the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder reconnect(String reconnect) {
            doSetProperty("reconnect", reconnect);
            return this;
        }
        /**
         * Waiting time before attempts reconnection (in milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2000
         * Group: common
         * 
         * @param reconnectTimeWait the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder reconnectTimeWait(int reconnectTimeWait) {
            doSetProperty("reconnectTimeWait", reconnectTimeWait);
            return this;
        }
        /**
         * Waiting time before attempts reconnection (in milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2000
         * Group: common
         * 
         * @param reconnectTimeWait the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder reconnectTimeWait(String reconnectTimeWait) {
            doSetProperty("reconnectTimeWait", reconnectTimeWait);
            return this;
        }
        /**
         * Interval to clean up cancelled/timed out requests.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 5000
         * Group: common
         * 
         * @param requestCleanupInterval the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder requestCleanupInterval(int requestCleanupInterval) {
            doSetProperty("requestCleanupInterval", requestCleanupInterval);
            return this;
        }
        /**
         * Interval to clean up cancelled/timed out requests.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 5000
         * Group: common
         * 
         * @param requestCleanupInterval the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder requestCleanupInterval(String requestCleanupInterval) {
            doSetProperty("requestCleanupInterval", requestCleanupInterval);
            return this;
        }
        /**
         * URLs to one or more NAT servers. Use comma to separate URLs when
         * specifying multiple servers.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param servers the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder servers(String servers) {
            doSetProperty("servers", servers);
            return this;
        }
        /**
         * Whether or not running in verbose mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param verbose the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder verbose(boolean verbose) {
            doSetProperty("verbose", verbose);
            return this;
        }
        /**
         * Whether or not running in verbose mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param verbose the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder verbose(String verbose) {
            doSetProperty("verbose", verbose);
            return this;
        }
        /**
         * the subject to which subscribers should send response.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param replySubject the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder replySubject(String replySubject) {
            doSetProperty("replySubject", replySubject);
            return this;
        }
        /**
         * Request timeout in milliseconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 20000
         * Group: producer
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder requestTimeout(long requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Request timeout in milliseconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 20000
         * Group: producer
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder requestTimeout(String requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * If we use useCredentialsFile to true we'll need to set the
         * credentialsFilePath option. It can be loaded by default from
         * classpath, but you can prefix with classpath:, file:, or http: to
         * load the resource from different systems.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param credentialsFilePath the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder credentialsFilePath(String credentialsFilePath) {
            doSetProperty("credentialsFilePath", credentialsFilePath);
            return this;
        }
        /**
         * Set secure option indicating TLS is required.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder secure(boolean secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Set secure option indicating TLS is required.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder secure(String secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder sslContextParameters(org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NatsEndpointProducerBuilder sslContextParameters(String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Nats component.
     */
    public interface AdvancedNatsEndpointProducerBuilder extends EndpointProducerBuilder {
        default NatsEndpointProducerBuilder basic() {
            return (NatsEndpointProducerBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Reference an already instantiated connection to Nats server.
         * 
         * The option is a: <code>io.nats.client.Connection</code> type.
         * 
         * Group: advanced
         * 
         * @param connection the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointProducerBuilder connection(io.nats.client.Connection connection) {
            doSetProperty("connection", connection);
            return this;
        }
        /**
         * Reference an already instantiated connection to Nats server.
         * 
         * The option will be converted to a
         * <code>io.nats.client.Connection</code> type.
         * 
         * Group: advanced
         * 
         * @param connection the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointProducerBuilder connection(String connection) {
            doSetProperty("connection", connection);
            return this;
        }
        /**
         * Define the header filtering strategy.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointProducerBuilder headerFilterStrategy(org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Define the header filtering strategy.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointProducerBuilder headerFilterStrategy(String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Whether or not connection trace messages should be printed to
         * standard out for fine grained debugging of connection issues.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param traceConnection the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointProducerBuilder traceConnection(boolean traceConnection) {
            doSetProperty("traceConnection", traceConnection);
            return this;
        }
        /**
         * Whether or not connection trace messages should be printed to
         * standard out for fine grained debugging of connection issues.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param traceConnection the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointProducerBuilder traceConnection(String traceConnection) {
            doSetProperty("traceConnection", traceConnection);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Nats component.
     */
    public interface NatsEndpointBuilder
            extends
                NatsEndpointConsumerBuilder,
                NatsEndpointProducerBuilder {
        default AdvancedNatsEndpointBuilder advanced() {
            return (AdvancedNatsEndpointBuilder) this;
        }

        /**
         * Timeout for connection attempts. (in milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2000
         * Group: common
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder connectionTimeout(int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Timeout for connection attempts. (in milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2000
         * Group: common
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder connectionTimeout(String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Define if we want to flush connection when stopping or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param flushConnection the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder flushConnection(boolean flushConnection) {
            doSetProperty("flushConnection", flushConnection);
            return this;
        }
        /**
         * Define if we want to flush connection when stopping or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param flushConnection the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder flushConnection(String flushConnection) {
            doSetProperty("flushConnection", flushConnection);
            return this;
        }
        /**
         * Set the flush timeout (in milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param flushTimeout the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder flushTimeout(int flushTimeout) {
            doSetProperty("flushTimeout", flushTimeout);
            return this;
        }
        /**
         * Set the flush timeout (in milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param flushTimeout the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder flushTimeout(String flushTimeout) {
            doSetProperty("flushTimeout", flushTimeout);
            return this;
        }
        /**
         * maximum number of pings have not received a response allowed by the
         * client.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param maxPingsOut the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder maxPingsOut(int maxPingsOut) {
            doSetProperty("maxPingsOut", maxPingsOut);
            return this;
        }
        /**
         * maximum number of pings have not received a response allowed by the
         * client.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param maxPingsOut the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder maxPingsOut(String maxPingsOut) {
            doSetProperty("maxPingsOut", maxPingsOut);
            return this;
        }
        /**
         * Max reconnection attempts.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 60
         * Group: common
         * 
         * @param maxReconnectAttempts the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder maxReconnectAttempts(int maxReconnectAttempts) {
            doSetProperty("maxReconnectAttempts", maxReconnectAttempts);
            return this;
        }
        /**
         * Max reconnection attempts.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 60
         * Group: common
         * 
         * @param maxReconnectAttempts the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder maxReconnectAttempts(String maxReconnectAttempts) {
            doSetProperty("maxReconnectAttempts", maxReconnectAttempts);
            return this;
        }
        /**
         * Turn off echo. If supported by the gnatsd version you are connecting
         * to this flag will prevent the server from echoing messages back to
         * the connection if it has subscriptions on the subject being published
         * to.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param noEcho the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder noEcho(boolean noEcho) {
            doSetProperty("noEcho", noEcho);
            return this;
        }
        /**
         * Turn off echo. If supported by the gnatsd version you are connecting
         * to this flag will prevent the server from echoing messages back to
         * the connection if it has subscriptions on the subject being published
         * to.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param noEcho the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder noEcho(String noEcho) {
            doSetProperty("noEcho", noEcho);
            return this;
        }
        /**
         * Whether or not randomizing the order of servers for the connection
         * attempts.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param noRandomizeServers the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder noRandomizeServers(boolean noRandomizeServers) {
            doSetProperty("noRandomizeServers", noRandomizeServers);
            return this;
        }
        /**
         * Whether or not randomizing the order of servers for the connection
         * attempts.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param noRandomizeServers the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder noRandomizeServers(String noRandomizeServers) {
            doSetProperty("noRandomizeServers", noRandomizeServers);
            return this;
        }
        /**
         * Whether or not running in pedantic mode (this affects performance).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param pedantic the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder pedantic(boolean pedantic) {
            doSetProperty("pedantic", pedantic);
            return this;
        }
        /**
         * Whether or not running in pedantic mode (this affects performance).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param pedantic the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder pedantic(String pedantic) {
            doSetProperty("pedantic", pedantic);
            return this;
        }
        /**
         * Ping interval to be aware if connection is still alive (in
         * milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 120000
         * Group: common
         * 
         * @param pingInterval the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder pingInterval(int pingInterval) {
            doSetProperty("pingInterval", pingInterval);
            return this;
        }
        /**
         * Ping interval to be aware if connection is still alive (in
         * milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 120000
         * Group: common
         * 
         * @param pingInterval the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder pingInterval(String pingInterval) {
            doSetProperty("pingInterval", pingInterval);
            return this;
        }
        /**
         * Whether or not using reconnection feature.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param reconnect the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder reconnect(boolean reconnect) {
            doSetProperty("reconnect", reconnect);
            return this;
        }
        /**
         * Whether or not using reconnection feature.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param reconnect the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder reconnect(String reconnect) {
            doSetProperty("reconnect", reconnect);
            return this;
        }
        /**
         * Waiting time before attempts reconnection (in milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2000
         * Group: common
         * 
         * @param reconnectTimeWait the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder reconnectTimeWait(int reconnectTimeWait) {
            doSetProperty("reconnectTimeWait", reconnectTimeWait);
            return this;
        }
        /**
         * Waiting time before attempts reconnection (in milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2000
         * Group: common
         * 
         * @param reconnectTimeWait the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder reconnectTimeWait(String reconnectTimeWait) {
            doSetProperty("reconnectTimeWait", reconnectTimeWait);
            return this;
        }
        /**
         * Interval to clean up cancelled/timed out requests.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 5000
         * Group: common
         * 
         * @param requestCleanupInterval the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder requestCleanupInterval(int requestCleanupInterval) {
            doSetProperty("requestCleanupInterval", requestCleanupInterval);
            return this;
        }
        /**
         * Interval to clean up cancelled/timed out requests.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 5000
         * Group: common
         * 
         * @param requestCleanupInterval the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder requestCleanupInterval(String requestCleanupInterval) {
            doSetProperty("requestCleanupInterval", requestCleanupInterval);
            return this;
        }
        /**
         * URLs to one or more NAT servers. Use comma to separate URLs when
         * specifying multiple servers.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param servers the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder servers(String servers) {
            doSetProperty("servers", servers);
            return this;
        }
        /**
         * Whether or not running in verbose mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param verbose the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder verbose(boolean verbose) {
            doSetProperty("verbose", verbose);
            return this;
        }
        /**
         * Whether or not running in verbose mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param verbose the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder verbose(String verbose) {
            doSetProperty("verbose", verbose);
            return this;
        }
        /**
         * If we use useCredentialsFile to true we'll need to set the
         * credentialsFilePath option. It can be loaded by default from
         * classpath, but you can prefix with classpath:, file:, or http: to
         * load the resource from different systems.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param credentialsFilePath the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder credentialsFilePath(String credentialsFilePath) {
            doSetProperty("credentialsFilePath", credentialsFilePath);
            return this;
        }
        /**
         * Set secure option indicating TLS is required.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder secure(boolean secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Set secure option indicating TLS is required.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder secure(String secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder sslContextParameters(org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NatsEndpointBuilder sslContextParameters(String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Nats component.
     */
    public interface AdvancedNatsEndpointBuilder
            extends
                AdvancedNatsEndpointConsumerBuilder,
                AdvancedNatsEndpointProducerBuilder {
        default NatsEndpointBuilder basic() {
            return (NatsEndpointBuilder) this;
        }

        /**
         * Reference an already instantiated connection to Nats server.
         * 
         * The option is a: <code>io.nats.client.Connection</code> type.
         * 
         * Group: advanced
         * 
         * @param connection the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointBuilder connection(io.nats.client.Connection connection) {
            doSetProperty("connection", connection);
            return this;
        }
        /**
         * Reference an already instantiated connection to Nats server.
         * 
         * The option will be converted to a
         * <code>io.nats.client.Connection</code> type.
         * 
         * Group: advanced
         * 
         * @param connection the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointBuilder connection(String connection) {
            doSetProperty("connection", connection);
            return this;
        }
        /**
         * Define the header filtering strategy.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointBuilder headerFilterStrategy(org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Define the header filtering strategy.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointBuilder headerFilterStrategy(String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Whether or not connection trace messages should be printed to
         * standard out for fine grained debugging of connection issues.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param traceConnection the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointBuilder traceConnection(boolean traceConnection) {
            doSetProperty("traceConnection", traceConnection);
            return this;
        }
        /**
         * Whether or not connection trace messages should be printed to
         * standard out for fine grained debugging of connection issues.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param traceConnection the value to set
         * @return the dsl builder
         */
        default AdvancedNatsEndpointBuilder traceConnection(String traceConnection) {
            doSetProperty("traceConnection", traceConnection);
            return this;
        }
    }

    public interface NatsBuilders {
        /**
         * Nats (camel-nats)
         * Send and receive messages from NATS messaging system.
         * 
         * Category: messaging
         * Since: 2.17
         * Maven coordinates: org.apache.camel:camel-nats
         * 
         * @return the dsl builder for the headers' name.
         */
        default NatsHeaderNameBuilder nats() {
            return NatsHeaderNameBuilder.INSTANCE;
        }
        /**
         * Nats (camel-nats)
         * Send and receive messages from NATS messaging system.
         * 
         * Category: messaging
         * Since: 2.17
         * Maven coordinates: org.apache.camel:camel-nats
         * 
         * Syntax: <code>nats:topic</code>
         * 
         * Path parameter: topic (required)
         * The name of topic we want to use
         * 
         * @param path topic
         * @return the dsl builder
         */
        default NatsEndpointBuilder nats(String path) {
            return NatsEndpointBuilderFactory.endpointBuilder("nats", path);
        }
        /**
         * Nats (camel-nats)
         * Send and receive messages from NATS messaging system.
         * 
         * Category: messaging
         * Since: 2.17
         * Maven coordinates: org.apache.camel:camel-nats
         * 
         * Syntax: <code>nats:topic</code>
         * 
         * Path parameter: topic (required)
         * The name of topic we want to use
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path topic
         * @return the dsl builder
         */
        default NatsEndpointBuilder nats(String componentName, String path) {
            return NatsEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Nats component.
     */
    public static class NatsHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final NatsHeaderNameBuilder INSTANCE = new NatsHeaderNameBuilder();

        /**
         * The timestamp of a consumed message.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NatsMessageTimestamp}.
         */
        public String natsMessageTimestamp() {
            return "CamelNatsMessageTimestamp";
        }
        /**
         * The SID of a consumed message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NatsSID}.
         */
        public String natsSID() {
            return "CamelNatsSID";
        }
        /**
         * The ReplyTo of a consumed message (may be null).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NatsReplyTo}.
         */
        public String natsReplyTo() {
            return "CamelNatsReplyTo";
        }
        /**
         * The Subject of a consumed message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NatsSubject}.
         */
        public String natsSubject() {
            return "CamelNatsSubject";
        }
        /**
         * The Queue name of a consumed message (may be null).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NatsQueueName}.
         */
        public String natsQueueName() {
            return "CamelNatsQueueName";
        }
    }
    static NatsEndpointBuilder endpointBuilder(String componentName, String path) {
        class NatsEndpointBuilderImpl extends AbstractEndpointBuilder implements NatsEndpointBuilder, AdvancedNatsEndpointBuilder {
            public NatsEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new NatsEndpointBuilderImpl(path);
    }
}